/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.properties;

import dev.toma.gunsrpg.util.properties.IPropertyHolder;
import dev.toma.gunsrpg.util.properties.IPropertySerializer;
import dev.toma.gunsrpg.util.properties.PropertyKey;
import dev.toma.gunsrpg.util.properties.PropertyRegistry;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;

public class PropertyContext
implements IPropertyHolder {
    private static final PropertyContext EMPTY = new PropertyContext(){

        @Override
        public <V> void setProperty(PropertyKey<V> key, V value) {
            throw new UnsupportedOperationException();
        }
    };
    private final Map<PropertyKey<?>, Object> map = new IdentityHashMap();

    private PropertyContext() {
    }

    public static PropertyContext empty() {
        return EMPTY;
    }

    public static PropertyContext create() {
        return new PropertyContext();
    }

    @Override
    public <V> void setProperty(PropertyKey<V> key, V value) {
        this.map.put(key, value);
    }

    @Override
    public boolean hasProperty(PropertyKey<?> key) {
        return this.map.containsKey(key);
    }

    @Override
    public <V> V getProperty(PropertyKey<V> key) {
        Object value = this.map.get(key);
        return (V)(value != null ? value : key.getDefaultValue());
    }

    @Override
    public <V> Optional<V> getOptionally(PropertyKey<V> key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    @Override
    public <V> void handleConditionally(PropertyKey<V> key, Predicate<V> condition, Consumer<V> action) {
        this.getOptionally(key).ifPresent(value -> {
            if (condition.test(value)) {
                action.accept(value);
            }
        });
    }

    @Override
    public <V> void moveContents(IPropertyHolder holder) {
        for (Map.Entry<PropertyKey<?>, Object> entry : this.map.entrySet()) {
            PropertyKey<?> key = entry.getKey();
            Object value = entry.getValue();
            holder.setProperty(key, value);
        }
    }

    @Override
    public <V> void encode(PacketBuffer buffer) {
        List synchronizables = this.map.entrySet().stream().filter(entry -> ((PropertyKey)entry.getKey()).isSerializable()).collect(Collectors.toList());
        buffer.func_150787_b(synchronizables.size());
        for (Map.Entry entry2 : synchronizables) {
            PropertyKey key = (PropertyKey)entry2.getKey();
            Object value = entry2.getValue();
            buffer.func_180714_a(key.getId());
            IPropertySerializer serializer = key.getSerializer();
            serializer.encode(buffer, value);
        }
    }

    @Override
    public <V> void decode(PacketBuffer buffer) {
        int properties = buffer.func_150792_a();
        for (int i = 0; i < properties; ++i) {
            String key = buffer.func_218666_n();
            PropertyKey propertyKey = PropertyRegistry.getById(key);
            IPropertySerializer serializer = propertyKey.getSerializer();
            Object value = serializer.decode(buffer);
            this.setProperty(propertyKey, value);
        }
    }
}

